/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CRMWOLock.cpp,v 1.1 1999/09/12 04:24:07 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "CRMWOLock.h"

_USING_PGP

// Class CRMWOLock member functions

CRMWOLock::CRMWOLock()
{
	mActiveReaders = mWaitingReader = mActiveWriters = mWaitingWriter = 0;
	mWritersFirst = TRUE;

#if !PGP_EXCEPTIONS
	Status() = mMutex.Status();

	if (Status().IsntError())
		Status() = mBlockedReaders.Status();

	if (Status().IsntError())
		Status() = mBlockedWriters.Status();
#endif	// PGP_EXCEPTIONS
}

void 
CRMWOLock::StartReading()
{
	mMutex.Enter();

	if ((mActiveWriters > 0) || (mWaitingWriter > 0))
	{
		mWaitingReader++;
		mMutex.Leave();

		mBlockedReaders.Wait();
	}
	else
	{
		mActiveReaders++;
		mMutex.Leave();
	}
}

void 
CRMWOLock::StopReading()
{
	mMutex.Enter();
	mActiveReaders--;

	if ((mActiveReaders == 0) && (mWaitingWriter > 0))
	{
		mActiveWriters = 1;
		mWaitingWriter--;

		mBlockedWriters.Signal();
	}

	mMutex.Leave();
}

void 
CRMWOLock::StartWriting()
{
	mMutex.Enter();

	if ((mActiveReaders == 0) || (mActiveWriters == 0))
	{
		mActiveWriters = 1;
		mMutex.Leave();
	}
	else
	{
		mWaitingWriter++;
		mMutex.Leave();

		mBlockedWriters.Wait();
	}
}

void 
CRMWOLock::StopWriting()
{
	mMutex.Enter();
	mActiveWriters = 0;

	// Alternate between releasing writers and readers first.

	if (mWritersFirst)
	{
		if (mWaitingReader > 0)
			ReleaseReaders();
		else if (mWaitingWriter > 0)
			ReleaseWriters();

		mWritersFirst = FALSE;
	}
	else
	{
		if (mWaitingWriter > 0)
			ReleaseWriters();
		else if (mWaitingReader > 0)
			ReleaseReaders();

		mWritersFirst = TRUE;
	}

	mMutex.Leave();
}

void 
CRMWOLock::ReleaseReaders()
{
	while (mWaitingReader > 0)
	{
		mWaitingReader--;
		mActiveReaders++;

		mBlockedReaders.Signal();
	}
}

void 
CRMWOLock::ReleaseWriters()
{
	mWaitingWriter--;
	mActiveWriters = 1;

	mBlockedWriters.Signal();
}
